#ifndef __CExpGainEditor__
#define __CExpGainEditor__

#include <ECore.h>
#include <EMusic.h>
#include <EGUI.h>
#include <EVST.h>

/**
 * @namespace Exponent
 * @brief Main Exponent namespace
 */
namespace Exponent
{
	/**
	 * @namespace ExpGain
	 * @brief ExpGain namespace
	 */
	namespace ExpGain
	{
		/**
		 * @class CExpGainEditor CExpGainEditor.hpp
		 * @brief Midi exp gain vst class
		 *
		 * @date 28/01/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CExpGainEditor.hpp,v 1.2 2007/03/03 02:59:53 paul Exp $
		 */
		class CExpGainEditor : public CVstWindow
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			/**
			 * Construction
			 * @param theEffect The audio effect
			 * @param windowArea The size of the window
			 * @param attributes The window attributes
			 */
			CExpGainEditor(AudioEffect *theEffect, const CRect &windowArea, CWindowAttributes *attributes);

			/**
			 * Destruction
			 */
			virtual ~CExpGainEditor();

//	===========================================================================

			/**
			 * Handle and action event
			 * @param event The event to handle
			 */
			virtual void handleActionEvent(const CActionEvent &event);

			/**
			 * Set parameter
			 * @param index The index of the parameter to set
			 * @param value The value of the parameter to set
			 */
			virtual void setParameter(const long index, const double value);

//	===========================================================================

		protected:

//	===========================================================================

			TAutomaticPointer<CTextLabel> m_label;						/**< Label for displaying the gain */
			TAutomaticPointer<CSlider> m_slider;						/**< The slider for the gain level */
		};
	}
}
#endif	// End of CExpGainEditor.hpp